#define  STRING_LENGTH  128
#define  MAX_BUFFERS    32
#define  INCL_OS2MM
#define  INCL_DOS

#include <os2.h>
#include <os2me.h>
#include <strings.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>

#include "config.h"
#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "gensound.h"
#include "sounddep/sound.h"
#include "events.h"
#include "uae.h"
#include "include/memory.h"
#include "custom.h"



HMTX                 sound_Msem=0;              // mutex semaphor for buffer update
HEV                  sound_sync_Esem=0,
                     soundbuf_ready;            // sem for sync
USHORT               usDeviceID;                // Amp Mixer device id
MCI_MIXSETUP_PARMS   MixSetupParms;             // Mixer parameters
MCI_BUFFER_PARMS     BufferParms;               // Device buffer parms
MCI_MIX_BUFFER       MixBuffers[MAX_BUFFERS];   // Device buffers
ULONG                ulNumBuffers;              // Number of buffers
ULONG                ulBufferSize;              // Size of a Buffer
ULONG                BufNr=0;                   // Current Buffer Nr
PVOID                sndBuf,sndptr,sndptrmax;   // pointer for the buffers
BYTE                 soundneutral;              // neutral sound value
ULONG                rc;                        // return code
ULONG                bufsamples;
ULONG                resetcount;
ULONG                soundoff=1;

VOID MciError(ULONG ulError)
{
   SZ       szBuffer[ STRING_LENGTH ] = " ";
   ULONG    rc2;

   rc2 = mciGetErrorString( ulError, szBuffer, STRING_LENGTH );
   if (rc)
     printf("Error: %d\n",ulError);
   else
     printf("Error: %ld - %s\n",ulError,szBuffer);

}

VOID clear_sound_buffers(VOID)
{
  ULONG     n;

   DosRequestMutexSem(sound_Msem,-1L);
   for (n=0; n<ulNumBuffers; n++) {
//     MixBuffers[n].ulBufferLength = ulBufferSize;         // not sure if to be set
     memset( MixBuffers[n].pBuffer,soundneutral, ulBufferSize );
     MixBuffers[n].ulUserParm = 0;
   }
   DosReleaseMutexSem(sound_Msem);
}

LONG APIENTRY MixEvent ( ULONG ulStatus, PMCI_MIX_BUFFER  pBuffer, ULONG  ulFlags)
{

      if (soundoff)
        return;
      DosPostEventSem(soundbuf_ready);
      DosWaitEventSem(sound_sync_Esem,-1L);
      DosRequestMutexSem(sound_Msem,-1L);
      MixSetupParms.pmixWrite( MixSetupParms.ulMixHandle,
                               &MixBuffers[BufNr],
                               1 );
      DosReleaseMutexSem(sound_Msem);
      DosResetEventSem(sound_sync_Esem,&resetcount);
      return(TRUE);
}

VOID flush_sound_buffer(VOID)
{
  DosWaitEventSem(soundbuf_ready,-1L);
  sndptr = sndBuf;
  DosRequestMutexSem(sound_Msem,-1L);
   if(BufNr == ulNumBuffers-1)
      BufNr = 0;
   else
     BufNr++;
  memcpy(MixBuffers[BufNr].pBuffer,sndBuf,ulBufferSize);
  DosReleaseMutexSem(sound_Msem);
  DosResetEventSem(soundbuf_ready,&resetcount);
  DosPostEventSem(sound_sync_Esem);
}

VOID start_sound( VOID )
{
   if (currprefs.produce_sound < 2)
     return;
   // clear the buffers
   clear_sound_buffers();
   BufNr = 0;

   // start playing
   rc = MixSetupParms.pmixWrite( MixSetupParms.ulMixHandle,
                                 &MixBuffers[0],
                                 ulNumBuffers-1 );
   if ( rc ) {
      printf("pmixWrite ");
      MciError( rc );
   }
}

BOOL init_sound_os2_dart(VOID)
{
  MCI_AMP_OPEN_PARMS   AmpOpenParms;
  ULONG i;


   if (currprefs.produce_sound < 0) {
      currprefs.produce_sound = 0;
      printf("FrameSync disabled.\n");
   } else {
/*
     if (!vsynctime) {
       printf ("Measuring clock rate...\n");
       i = read_processor_time ();
       _sleep2 (1000);
       i = read_processor_time () - i;
       printf ("Your machine is running at approx. %d Hz\n", i);
       syncbase = i;
       vsynctime = i / 50;
     } else if (vsynctime > 0) {
       vsynctime *= 1000 / 50;
       printf ("vsync * 20 \n");
     }
     else {
       vsynctime = 0;
       printf ("vsync set to 0.\n");
     }
     if (!vsynctime)
       printf ("No performance counters available. Bad.\n");
     else
       printf ("FrameSync enabled. Ticks per frame: %d\n", vsynctime);
*/
   }

   // create the Mutex Sem for da buffers
   rc = DosCreateMutexSem(NULL,&sound_Msem,0L,0L);
   if (rc) {
     printf("Error creating the MUTEX SEM\n");
     return( TRUE );
   }

   rc = DosCreateEventSem(NULL,&sound_sync_Esem,0L,0L);
   if (rc) {
     printf("Error creating the EVENT SEM\n");
     return( TRUE );
   }

   rc = DosCreateEventSem(NULL,&soundbuf_ready,0L,0L);
   if (rc) {
     printf("Error creating the EVENT SEM\n");
     return( TRUE );
   }

   // getting ID for the mixer device
   bzero(  &AmpOpenParms, sizeof( MCI_AMP_OPEN_PARMS ) );

   AmpOpenParms.usDeviceID    = ( USHORT ) 0;
   AmpOpenParms.pszDeviceType = ( PSZ ) MCI_DEVTYPE_AUDIO_AMPMIX;
   rc = mciSendCommand( 0,
                        MCI_OPEN,
                        MCI_WAIT | MCI_OPEN_TYPE_ID | MCI_OPEN_SHAREABLE,
                        ( PVOID ) &AmpOpenParms,
                        0 );
   if ( ULONG_LOWD(rc) != MCIERR_SUCCESS) {
      printf("MCI_OPEN  ");
      MciError( rc );
      return( TRUE );
   }

   usDeviceID = AmpOpenParms.usDeviceID;

   // set the mixer device
   bzero( &MixSetupParms, sizeof( MCI_MIXSETUP_PARMS ) );

   MixSetupParms.ulFormatMode    = MCI_PLAY;                   // set it to play
   MixSetupParms.pmixEvent       = MixEvent;                   // the event handler
   MixSetupParms.ulFormatTag     = MCI_WAVE_FORMAT_PCM;        // set to PCM
   MixSetupParms.ulBitsPerSample = currprefs.sound_bits;       // bit
   MixSetupParms.ulSamplesPerSec = currprefs.sound_freq;       // freq
   MixSetupParms.ulChannels      = currprefs.stereo + 1;       // mono|stereo
   MixSetupParms.ulDeviceType    = MCI_DEVTYPE_WAVEFORM_AUDIO; // set the kind of the device

   rc = mciSendCommand( usDeviceID,
                        MCI_MIXSETUP,
                        MCI_WAIT | MCI_MIXSETUP_INIT,
                        ( PVOID ) &MixSetupParms,
                        0 );

   if (rc!=MCIERR_SUCCESS) {
      printf("MCI_MIXSETUP  ");
      MciError( rc );
      return( TRUE );
   }


   ulBufferSize = 64*(currprefs.sound_freq/11025) * (currprefs.sound_bits/8) * (currprefs.stereo+1);

   if (ulBufferSize > 1024*32)
     ulBufferSize = 1024*32;

   ulNumBuffers = ((currprefs.sound_freq * (MixSetupParms.ulBitsPerSample/8)
                    * MixSetupParms.ulChannels) / ulBufferSize) +1;
//   printf("ulBufferSize = %d\n",ulBufferSize);
   if (ulNumBuffers>MAX_BUFFERS)
     ulNumBuffers=MAX_BUFFERS;

   // allocate mem for the buffers
   bzero(&BufferParms,sizeof(MCI_BUFFER_PARMS));

   BufferParms.ulNumBuffers = ulNumBuffers;
   BufferParms.ulBufferSize = ulBufferSize;;
   BufferParms.pBufList     = MixBuffers;

   rc = mciSendCommand( usDeviceID,
                        MCI_BUFFER,
                        MCI_WAIT | MCI_ALLOCATE_MEMORY,
                        ( PVOID ) &BufferParms,
                        0 );
   if (rc!=MCIERR_SUCCESS ) {
      printf("MCI_BUFFER  ");
      MciError( rc );
      return( TRUE );
   }
   sndptr    = sndBuf = malloc(ulBufferSize);
   sndptrmax = sndBuf + ulBufferSize;

   return( FALSE );
}

void stop_sound(void)
{
 MCI_GENERIC_PARMS    GenericParms;

   if (currprefs.produce_sound < 2)
     return;
   DosPostEventSem(sound_sync_Esem);
   rc = mciSendCommand( usDeviceID,
                        MCI_STOP,
                        MCI_WAIT,
                        ( PVOID )&GenericParms,
                        0 );
   DosPostEventSem(sound_sync_Esem);
   if ( rc != MCIERR_SUCCESS) {
      printf("MCI_STOP ");
      MciError( rc );
      return;
   }
}

VOID close_sound( VOID )
{
   MCI_GENERIC_PARMS    GenericParms;

   if (soundoff)
     return;
   soundoff = 1;
   stop_sound();
   DosCloseEventSem(sound_sync_Esem);
   DosCloseMutexSem(sound_Msem);
   rc = mciSendCommand( usDeviceID,
                        MCI_BUFFER,
                        MCI_WAIT | MCI_DEALLOCATE_MEMORY,
                        ( PVOID )&BufferParms,
                        0 );
   if ( rc != MCIERR_SUCCESS ) {
      printf("MCI_BUFFER_DEALLOC ");
      MciError( rc );
      return;
   }

   DosPostEventSem(sound_sync_Esem);
   rc = mciSendCommand( usDeviceID,
                        MCI_CLOSE,
                        MCI_WAIT ,
                        ( PVOID )&GenericParms,
                        0 );
   if ( rc != MCIERR_SUCCESS ) {
      printf("MCI_CLOSE ");
      MciError( rc );
      return;
   }
//   printf("close_sound\n");
}

int setup_sound (void)
{
    sound_available = 1;
    return 1;
}

int init_sound (void)
{
    int rate;

   if (init_sound_os2_dart())
      return 0;

   sample_evtime = (long) maxhpos *maxvpos * 50 / currprefs.sound_freq;

   if (currprefs.sound_bits == 16) {
      init_sound_table16 ();
      sample_handler = currprefs.stereo ? sample16s_handler : sample16_handler;
      soundneutral = 0;
   } else {
      init_sound_table8 ();
      sample_handler = currprefs.stereo ? sample8s_handler : sample8_handler;
      soundneutral = 128;
   }

   // here we go...
   start_sound();
   printf("Sound driver found and configured for %d bits at %d Hz %s\n",
           currprefs.sound_bits, currprefs.sound_freq, currprefs.stereo ? "stereo" : "");
   soundoff = 0;
   return 1;
}

